<?php
include 'db.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['barcodeData'])) {
    // Get barcode data from user input (e.g., SKU)
    $barcodeData = $_POST['barcodeData'];

    // Debug: Check if the barcode data is being received
    var_dump($_POST);

    // Function to generate a barcode image based on the input data
    function generateBarcode($data, $width = 400, $height = 150) {
        // Ensure the input data is a string
        $barcode = $data;
    
        // Code 128 Barcode pattern
        $code128 = [
            " " => "212222", "!" => "222122", "\"" => "222221", "#" => "121223", "$" => "121322", "%" => "131222",
            "&" => "122213", "'" => "122312", "(" => "132212", ")" => "131222", "*" => "122113", "+" => "122212",
            "," => "122221", "-" => "121213", "." => "121312", "/" => "131213", "0" => "223211", "1" => "221132",
            "2" => "221221", "3" => "213212", "4" => "223112", "5" => "312131", "6" => "311222", "7" => "321122",
            "8" => "321221", "9" => "312212", ":" => "322112", ";" => "322211", "<" => "212123", "=" => "212132",
            ">" => "212221", "?" => "213121", "@" => "211213", "A" => "211312", "B" => "231212", "C" => "233111",
            "D" => "211131", "E" => "211231", "F" => "233111", "G" => "213131", "H" => "211312", "I" => "212213",
            "J" => "213112", "K" => "231131", "L" => "233121", "M" => "231132", "N" => "232111", "O" => "213212",
            "P" => "233111", "Q" => "231222", "R" => "222112", "S" => "212111", "T" => "213112", "U" => "221132",
            "V" => "221221", "W" => "221212", "X" => "212213", "Y" => "212221", "Z" => "222211", "[" => "212121",
            "\\" => "213221", "]" => "223121", "^" => "222112", "_" => "211231", "`" => "231212", "a" => "232111",
            "b" => "221113", "c" => "221312", "d" => "231112", "e" => "211232", "f" => "221223", "g" => "222121",
            "h" => "211231", "i" => "232212", "j" => "211221", "k" => "233211", "l" => "213112", "m" => "213122",
            "n" => "212212", "o" => "231112", "p" => "233121", "q" => "221221", "r" => "231121", "s" => "213213",
            "t" => "212132", "u" => "233222", "v" => "211233", "w" => "232221", "x" => "232111", "y" => "223121",
            "z" => "222112", "{" => "211211", "|" => "212121", "}" => "231221", "~" => "212212", "DEL" => "231222"
        ];
    
        // Start with the Start Code and stop codes
        $startCode = "212222"; // Start code for Code 128
        $stopCode = "2331112"; // Stop code for Code 128
    
        // Encode the barcode data into the barcode pattern
        $barcodePattern = $startCode;
    
        // Loop through each character in the barcode data
        foreach (str_split($barcode) as $char) {
            if (isset($code128[$char])) {
                $barcodePattern .= $code128[$char];
            }
        }
    
        // Add stop code
        $barcodePattern .= $stopCode;
    
        // Create the barcode image with updated width and height
        $barcodeWidth = strlen($barcodePattern) * 2; // Adjust width based on the pattern
        $image = imagecreatetruecolor($barcodeWidth, $height);
    
        // Define colors
        $white = imagecolorallocate($image, 255, 255, 255);
        $black = imagecolorallocate($image, 0, 0, 0);
    
        // Fill the background with white
        imagefill($image, 0, 0, $white);
    
        // Draw the barcode bars
        $xPosition = 10;
        foreach (str_split($barcodePattern) as $bar) {
            $color = ($bar == "1") ? $black : $white;
            imagefilledrectangle($image, $xPosition, 10, $xPosition + 3, $height - 30, $color); // Adjust bar width to make it thicker
            $xPosition += 3; // Move to next position
        }
    
        // Add barcode text below the barcode
        $fontSize = 5;
        $textWidth = imagefontwidth($fontSize) * strlen($barcode);
        $xTextPosition = ($barcodeWidth - $textWidth) / 2;
        $yTextPosition = $height - 15;
    
        imagestring($image, $fontSize, $xTextPosition, $yTextPosition, $barcode, $black);
    
        // Generate a unique filename for the barcode image
        $timestamp = time();
        $imagePath = 'barcodes/barcode_' . $timestamp . '.png';
    
        // Output the image to the file
        imagepng($image, $imagePath);
    
        // Free up memory
        imagedestroy($image);
    
        return $imagePath;
    }
    // Generate the barcode image
    $imagePath = generateBarcode($barcodeData);

    // Insert barcode data into MySQL (without prepared statements as per your request)
    $sql = "INSERT INTO barcodes (barcode_data, barcode_image) VALUES ('$barcodeData', '$imagePath')";

    if ($conn->query($sql) === TRUE) {
        echo "Barcode generated and saved successfully!";
    } else {
        echo "Error: " . $conn->error;
    }
} else {
    echo "No data received!";
}

// Close connection
$conn->close();
?>
